'***********************
'Simple but Flexible Timer Switch
'Picaxe 08M.
'Copyright Phillip Webb 19 June 2010.
'Ver 4. 
'Added ability to change/setup time in increments of 10 minutes. 10 to 180 minutes available.
'Press button while powering up changes to setup mode.
'Each flash of the LEDLamp indicates 10 minutes of timing when in setup mode and immediately after power on.
'Power off to exit out of setup mode.
'LEDLamp mark/space ratio indicates time remaining - Short flash - almost time up.
'Added fast flash to indicate start of Setup Mode
'Progamme must be no more than 255 bytes long to ensure Byte 255 is free for saving the delay setting.
'***********************
'Declare variables and constants
symbol counter = w0 ' b0 & b1 up 65535
symbol Onleddelay = w1 'b2 & b3 'pause for LED
symbol xtime = w2 'b4 & b5 'pseudo time delay
symbol toggleflag = b6 ' 0 - delay off 1 = dealy on
symbol tenminutes = b7 ' value range is 1 to 18
symbol pushbutton = pin1
symbol ledlamp = 2
symbol relay = 4
'delay is xtime squared in milli seconds
'xtime = int (sqrt(60000 * delay in minutes)) eg: 1897 = 1 hour
'xtime = int (sqrt(1000 * delay in seconds)) eg: 245 = 60 secs
'delay in mins = (xtime * xtime/60000)
'delay in seconds = (xtime * xtime/1000)
'max delay is xtime = 65535 = 71580 minutes = 1193 hrs = 49.7 days
'60 mins = 1897
'1 mins = 245
'30 secs = 173
'10 secs = 100
'5 sec = 70
'*************************
'read the default delay time from EEPROM location 255
read 255 , tenminutes
select case tenminutes 'set to default time of 60 minutes
	case <1
		tenminutes = 6
	case >18
		 tenminutes = 6
end select
gosub lookuptenminutes

'**************************
Startup:
gosub flashled
if pushbutton = 1 then 'enter setup mode
	goto setup
end if
setint %00000010,%00000010 'establish the interrupt to ensure pushbutton is responsive during time delay

'**************************
main:
	if toggleflag = 1 then goto timingon
goto main
'***************************
interrupt:
if pushbutton = 1 then interrupt 'loop here until the pushbutton released
if toggleflag = 1 then
	toggleflag = 0
else
	toggleflag = 1
end if
 interrupt cleared
pause 50 wait
setint %00000010,%10000010 ' re-activate interrupt
return 'from sub

'***************************
'Start the timing
timingon:
high relay 
for counter = 1 to xtime 'main time delay loop. each count is a delay of xtime. this routine changes the mark space ratio of LED 
	if toggleflag = 0 then 'toggleflag is re-set by the interrupt routine 
		low relay
		low ledlamp
		goto main
	end if
	low ledlamp 
	pause counter 'First of 2 pauses Led off
	high LEDlamp
	onleddelay = xtime - counter
	pause  onleddelay 'Second pause Led on. Total pause = (counter + xtime - counter) = xtime
	'Thus total pause time = xtime * xtime in milliseconds
next counter
'force relay off after elapsed time
toggleflag = 0
low relay
low LEDLamp
goto main

'**************************
setup:   'modify the timing. Power down to save and reset.
for counter = 1 to 100' fast flash to indicate setup mode
	toggle LEDLamp
	pause 20
next counter
do
lookdown xtime , (0,774,1095,1341,1549,1732,1897,2049,2190,2323,2449,2569,2683,2792,2898,3000,3098,3193,3286) ,tenminutes
if pushbutton = 1 then 
	tenminutes = tenminutes +1 ' increase time delay
	if tenminutes > 18 then  ' reset to 10 if more than 180 minutes)
		tenminutes = 1
	end if
	gosub lookuptenminutes
	pause 500
	gosub flashLED 
	write 255 , tenminutes ' write to EEProm
end if
loop
'**************************
'Flash LEDs once for every 10 minutes of delay
Flashled:
		for counter = 1 to tenminutes
			high ledlamp
			pause 250
			low ledlamp
			pause 250
		next counter
		'low ledlamp
		pause 1000
return
'**************************
'convert ten minutes to XTime
lookuptenminutes:
lookup tenminutes, (0,774,1095,1341,1549,1732,1897,2049,2190,2323,2449,2569,2683,2792,2898,3000,3098,3193,3286) ,xtime
return

